/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.server;

import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCSubscription;
import com.ibm.hsc.indication.server.HSCConnListener;
import com.ibm.hsc.indication.server.HSCListener;
import com.ibm.hsc.indication.server.HSCTimeoutMonitor;
import com.ibm.hsc.rep.RObject;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;

public class HSCEventIndicationMgr
extends Thread {
    public static HSCEventIndicationMgr mInstance = null;
    protected long mCreationTime = 0L;
    protected Vector mListeners;
    protected Hashtable mHandlers;
    protected Vector mAuthKeys = null;
    private boolean mTestOnly = false;
    private Hashtable mCltInfo = new Hashtable();

    public HSCEventIndicationMgr(int n) {
        System.out.println("created HSCEventIndicationMgr");
        this.mListeners = new Vector();
        this.mHandlers = new Hashtable();
        HSCConnListener hSCConnListener = new HSCConnListener(this, n);
        this.mAuthKeys = new Vector();
        this.mCreationTime = System.currentTimeMillis();
        hSCConnListener.start();
        this.start();
        new HSCTimeoutMonitor(this.mListeners).start();
    }

    private void setTestOnly() {
        this.mTestOnly = true;
    }

    public void addListenerSite(HSCListener hSCListener) {
        System.out.println("add listener");
        this.mListeners.addElement(hSCListener);
    }

    public void subscribe(HSCSubscription hSCSubscription, HSCListener hSCListener) {
        String string = hSCListener.subscribe(hSCSubscription);
        if (string == null) {
            return;
        }
        Vector<HSCListener> vector = (Vector<HSCListener>)this.mHandlers.get(string);
        if (vector == null) {
            vector = new Vector<HSCListener>();
            this.mHandlers.put(string, vector);
        }
        if (vector.indexOf(hSCListener) == -1) {
            vector.addElement(hSCListener);
        }
    }

    public void unsubscribe(HSCSubscription hSCSubscription, HSCListener hSCListener) {
        String string = null;
        if (hSCSubscription != null) {
            string = hSCListener.subscribe(hSCSubscription);
            if (string == null) {
                return;
            }
            this.unsubscribeEvt(string, hSCListener);
        } else {
            Vector vector = hSCListener.getEventKeys();
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.elementAt(i);
                this.unsubscribeEvt(string, hSCListener);
            }
            this.mListeners.removeElement(hSCListener);
            System.out.println("removing listener...... ");
            hSCListener.printStatus();
            String string2 = hSCListener.getAuthKey();
            if (string2 != null) {
                Object v = this.mCltInfo.remove(string2);
                System.out.println("removing client " + v + "auth key " + string2);
                this.mAuthKeys.remove(string2);
            }
        }
    }

    private void unsubscribeEvt(String string, HSCListener hSCListener) {
        Vector vector = (Vector)this.mHandlers.get(string);
        vector.removeElement(hSCListener);
        if (vector.size() == 0) {
            this.mHandlers.remove(string);
        }
    }

    public void handleEvent(int n, String string, Object object, Object object2, long l) {
        HSCEvent hSCEvent = new HSCEvent(n, string, object, object2, l);
        this.handleEvent(hSCEvent);
    }

    private String getObjectType(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CIMInstance) {
            CIMInstance cIMInstance = (CIMInstance)object;
            return cIMInstance.getClassName();
        }
        if (object instanceof RObject) {
            RObject rObject = (RObject)object;
            return rObject.getSchema().getClassName();
        }
        return "unknow";
    }

    public void sendIndication(int n, Object object, Object object2) {
        String string = this.getObjectType(object);
        this.handleEvent(n, string, this.getRObject(object2), this.getRObject(object), System.currentTimeMillis());
    }

    private Object getRObject(Object object) {
        try {
            if (object instanceof CIMInstance) {
                return new RObject("root/ibmhscS1_0", (CIMInstance)object);
            }
            return object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void handleEvent(HSCEvent hSCEvent) {
        String string = hSCEvent.getEventKey();
        Vector vector = (Vector)this.mHandlers.get(string);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                HSCListener hSCListener = (HSCListener)vector.elementAt(i);
                hSCListener.deliverEvent(hSCEvent);
            }
        }
    }

    public void run() {
        while (true) {
            boolean bl = false;
            for (int i = 0; i < this.mListeners.size(); ++i) {
                HSCListener hSCListener = (HSCListener)this.mListeners.elementAt(i);
                try {
                    if (hSCListener.isNeedClose()) {
                        System.out.println("Client is down");
                        this.unsubscribe(null, hSCListener);
                        hSCListener.close();
                        bl = true;
                        break;
                    }
                    HSCSubscription hSCSubscription = hSCListener.readSubscription();
                    if (hSCSubscription == null || !this.securityCheck(hSCSubscription)) continue;
                    System.out.println("authenticated");
                    if (hSCSubscription.isSubscription()) {
                        this.subscribe(hSCSubscription, hSCListener);
                    } else {
                        this.unsubscribe(hSCSubscription, hSCListener);
                    }
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    try {
                        throwable.printStackTrace(System.out);
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
                        this.unsubscribe(null, hSCListener);
                        hSCListener.close();
                        bl = true;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    break;
                }
            }
            if (bl) continue;
            try {
                HSCEventIndicationMgr.sleep(5000L);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean securityCheck(HSCSubscription hSCSubscription) {
        if (this.mTestOnly) {
            return true;
        }
        return this.mAuthKeys.indexOf(hSCSubscription.getAuthKey()) != -1;
    }

    public synchronized String getAuthKey(String string, long l, String string2) {
        String string3 = this.createAuthKey(string, l);
        if (string3 == null) {
            return "";
        }
        int n = this.mAuthKeys.indexOf(string3);
        if (this.mAuthKeys.indexOf(string3) == -1) {
            this.mAuthKeys.addElement(string3);
            string2 = "hostName: " + string + "\nClient CreationTime: " + new Timestamp(l) + "\n" + string2;
            System.out.println("add new client authKey:" + string3 + " clientInfo: " + string2);
            this.mCltInfo.put(string3, string2);
        }
        return string3;
    }

    private String createAuthKey(String string, long l) {
        return string + "." + this.mCreationTime + "." + l;
    }

    public boolean eventHasSubscription(int n) {
        Enumeration enumeration = this.mHandlers.keys();
        String string = "" + n + "-";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static synchronized HSCEventIndicationMgr getInstance() {
        if (mInstance == null) {
            mInstance = new HSCEventIndicationMgr(-1);
        }
        return mInstance;
    }

    public void printStatus() {
        System.out.println("-------- Start Print Indication Server Status .......");
        for (int i = 0; i < this.mListeners.size(); ++i) {
            HSCListener hSCListener = (HSCListener)this.mListeners.elementAt(i);
            System.out.println("-------- Begin Indication Listener Status");
            hSCListener.printStatus();
            String string = hSCListener.getAuthKey();
            if (string != null) {
                String string2 = (String)this.mCltInfo.get(string);
                System.out.println("Client Info: " + string2);
            }
            System.out.println("-------- End Indication Listener Status");
        }
        System.out.println("-------- End Print Indication Server Status --------------------");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length < 4) {
            System.out.println("Usage:");
            System.out.println("java -Djavax.net.ssl.keyStore=/usr/websm/codebase/SM.prikr -Djavax.net.ssl.keyStorePassword=defp -DcimomConfigFile=/opt/hsc/data/cimomcfg.properties com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventIndicationMgr server_port event_source_object_type {event_types}");
            return;
        }
        try {
            var1_1 = new HSCEventIndicationMgr(Integer.parseInt(var0[0]));
            var1_1.setTestOnly();
            var2_3 = 0L;
            while (true) {
                for (var4_4 = 2; var4_4 < var0.length; ++var4_4) {
                    var1_1.handleEvent(Integer.parseInt(var0[var4_4]), var0[1], "oldstring***************************************************************************************************************" + var2_3, "newstring***************************************************************************************************************************************************************" + var2_3, System.currentTimeMillis());
                }
                if (++var2_3 % 1000L != 0L) ** continue;
                System.gc();
            }
        }
        catch (Exception var1_2) {
            var1_2.printStackTrace();
            HSCLogUtils.serverLog(var1_2, HSCLogUtils._IndicationClassLogInfo);
            return;
        }
    }
}

